#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "map.h"
#include "gmstuff.h"
#include "mapstuff.h"
#include "switchstuff.h"
#include "linkstuff.h"

char *Mapfile1;
char *Routefile1;
char *Mapfile2;
char *Routefile2;

void
parse_args(
  int argc,
  char **argv)
{
  if (argc != 5) {
    fprintf(stderr, "Usage: routemerge <map1> <routes1> <map2> <routes2>\n");
    fprintf(stderr, "	map1 should be a superset of map2\n");
    exit(1);
  }

  Mapfile1 = argv[1];
  Routefile1 = argv[2];
  Mapfile2 = argv[3];
  Routefile1 = argv[4];
}

int
main(
  int argc,
  char **argv)
{
  struct mapfile mf1, mf2;
  struct mapfile *mp1, *mp2;
  struct routefile rf1, rf2;
  struct routefile *rp1, *rp2;

  parse_args(argc, argv);

  mp1 = &mf1;
  mp1->name = Mapfile1;
  load_map_file(mp1);

  rp1 = &rf1;
  rp1->name = Routesfile1;
  load_route_file(rp1, mp1);

  mp2 = &mf2;
  mp2->name = Mapfile2;
  load_map_file(mp2);

  rp2 = &rf2;
  rp2->name = Routesfile2;
  load_route_file(rp2, mp2);

  merge_routes(mp1, rp1, mp2, rp2);

  write_routes(mp1, rp1);

  return 0;
}
